% Skript realer_widerstand_1.m in dem die Impedanz der
% Ersatzschaltung eines realen Widerstands untersucht wird

clear;
% ------- Parameter der Ersatzschaltung
R = 10e3;       
L = 1e-6;    C = 5e-12;

% ------- Frequenzbereich 
f0 = 1/(2*pi*sqrt(L*C));     % Resonanzfrequenz
a1 = floor(log10(f0/100000));  
a2 = ceil(log10(f0*10));
f = logspace(a1, a2, 1000);  % 1000 logarithmische Frequenzwerte 
omega = 2*pi*f;

% ------- Impedanz
Z1 = j*omega*L; 
Z2 = 1./(j*omega*C);
Z = Z1 + Z2*R./(Z2 + R);

Betrag = abs(Z);
Winkel = angle(Z)*180/pi;   % Grad

figure(1);     clf;
subplot(211), loglog(f, Betrag);
title('Betrag der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Ohm')

subplot(212), semilogx(f, Winkel);
title('Winkel der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Grad');