% Skript realer_kondensator_1.m in dem die Impedanz der
% Ersatzschaltung eines realen Kondensators untersucht wird

clear;
% ------- Parameter der Ersatzschaltung
Rcs = 1;       Rcp = 10e6;
L = 0.1e-6;    C = 2.4e-9;

% ------- Frequenzbereich 
f0 = 1/(2*pi*sqrt(L*C));     % Resonanzfrequenz
a1 = floor(log10(f0/100000));  
a2 = ceil(log10(f0*10));
f = logspace(a1, a2, 1000);  % 1000 logarithmische Frequenzwerte 
omega = 2*pi*f;

% ------- Impedanz
Z1 = j*omega*L + Rcs;
Z2 = 1./(j*omega*C);
Z3 = Rcp;

ZC = Z1 + (Z2.*Z3)./(Z2 + Z3);
Betrag = abs(ZC);
Winkel = angle(ZC)*180/pi;   % Grad

figure(1);     clf;
subplot(211), loglog(f, Betrag);
title('Betrag der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Ohm')

subplot(212), semilogx(f, Winkel);
title('Winkel der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Grad');