% Skript realer_induktor_1.m in dem die Impedanz der
% Ersatzschaltung eines realen Induktor untersucht wird

clear;
% ------- Parameter der Ersatzschaltung
Rv = 0.1;       L = 20e-6;
C = 0.5e-12;

% ------- Frequenzbereich 
f0 = 1/(2*pi*sqrt(L*C));     % Resonanzfrequenz
a1 = floor(log10(f0/100000));  
a2 = ceil(log10(f0*10));
f = logspace(a1, a2, 1000);  % 1000 logarithmische Frequenzwerte 
omega = 2*pi*f;

% ------- Impedanz
Z1 = j*omega*L + Rv;
Z2 = 1./(j*omega*C);

ZL = (Z1.*Z2)./(Z1 + Z2);
Betrag = abs(ZL);
Winkel = angle(ZL)*180/pi;   % Grad

figure(1);     clf;
subplot(211), loglog(f, Betrag);
title('Betrag der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Ohm')

subplot(212), semilogx(f, Winkel);
title('Winkel der Impedanz');
xlabel('Frequenz in HZ');     grid on;
ylabel('Grad');