% Skript quarz_1.m in dem die Impedanz eines Quarzes
% untersucht wird

clear;
% ------- Parameter der Schaltung
R = 20;
C = 10e-12;
C0 = 5.e-12;
L = 10e-6;

% Reihenresonanz
f0rh = 1/(2*pi*sqrt(L*C));
Ce = C*C0/(C + C0)
f0pl = 1/(2*pi*sqrt(L*Ce));

a1 = round(log10(f0rh/10)); % Zwei Dekaden links
a2 = round(log10(f0rh*10)); % Zwei Dekaden rechts
f = logspace(a1, a2, 5000);   % Frequenzbereich
omega = 2*pi*f;

Z1 = R + j*omega*L + 1./(j*omega*C);
Z2 = 1./(j*omega*C0);

Z = (Z1.*Z2)./(Z1 + Z2);

% ------ Darstellung der Impedanz als Betrag und Winkel
betrag = abs(Z);
winkel = angle(Z);

figure(1);    clf;
subplot(211), loglog(f, betrag);
title(' Betrag der Impedanz');
xlabel('Hz');    grid on;
ylabel('Ohm');
hold on
La = axis;
plot([f0rh, f0rh], [La(3:4)],'r');
plot([f0pl, f0pl], [La(3:4)],'r');
hold off;

subplot(212), semilogx(f, winkel*180/pi);
title(' Winkel der Impedanz');
xlabel('Hz');    grid on;
ylabel('Grad');
hold on
La = axis;
plot([f0rh, f0rh], [La(3:4)],'r');
plot([f0pl, f0pl], [La(3:4)],'r');
hold off;






