% Skript oszillat_2.m in dem ein Oszillator mit
% Reihenresonanzkreis untersucht wird


clear;
% ------ Parameter der Schaltung
R1 = 1000;      L = 200e-6;
C = 500e-12;
R2 = 1000;

alpha = 1.05;
Aopt = alpha*(R1 + R2)/R2;
iL0 = 1e-3;
uc0 = 1;
f0rh = 1/(2*pi*sqrt(L*C));
T0 = 1/f0rh;

% ------ Numerische Integration
dt = T0/10000;
Tfinal = 10*T0;
t = 0:dt:Tfinal;

nt = length(t);
iL = zeros(1,nt);    uc = zeros(1,nt);

iL(1) = iL0;         uc(1) = uc0;
ub_min = 4;          % Eingangsspannung die zur
%Sttigung fhrt
for k = 1:nt-1
    ub = iL(k)*R2;
    Aopt_temp = Aopt*(ub < ub_min & ub > -ub_min);
    iL(k+1) = iL(k) + dt*(-iL(k)*(R1 + R2*(1-Aopt_temp)) - uc(k))/L;
    uc(k+1) = uc(k) + dt*(iL(k+1))/C;
end;
ub = iL*R2;
uausg = ub*Aopt;

figure(1);    clf;
plot(t, uc, t, ub, t, uausg);
title(['Spannungen uc, ub und uausg ( A = ',...
    num2str(alpha),'*Aopt)']); 
xlabel('Zeit in s');  grid on;
legend('uc', 'ub', 'uausg');