% Skript ortsk_rlc_parallel2.m in dem eine Ortskurve
% fr das RLC-Parallelkreis berchnet und dargestellt wird

clear;

% ------- Parameter der Impedanz
C = 100e-12;
L = 20e-6;
f0r = 1/(2*pi*sqrt(L*C));

L0 = L*2*pi*f0r;
C0 = C*2*pi*f0r;

% R und Omega werden als Parameter gewhlt

%f = [logspace(-1, 0, 200), logspace(0, 1, 200)];
                             % Relative Frequenz
f = logspace(-1, 1, 500);
f = sort([f,1]);

omega = f;          % Absolute Frequenz
nf = length(f);

R = 100:100:1000;            % bereich fr R
nR = length(R);

Z = zeros(nR, nf);           % Initialisierungen
Y = Z;
for k = 1:nR
    Y(k,:) = 1./R(k) + 1./(j*omega*L0) + j*omega*C0;
end;
Z = 1./Y;

%####################################
figure(1);
plot(real(Z(1,:)), imag(Z(1,:)));
hold on
for k = 2:nR
    plot(real(Z(k,:)), imag(Z(k,:)));
end;
for k = 1:10:nf
    plot(real(Z(:,k)), imag(Z(:,k)));
    if (k > 80)& k<(nf-80),
        text(real(Z(end,k)), imag(Z(end,k)), num2str(f(k)));
    end;    
end;
hold off
grid on;
title('Ortskurve der Impedanz der RLC-Parallelschaltung');
xlabel('Ohm');
La = axis;    axis(La*1.1)

%####################################
% ------ Darstellung als Betrag und Winkel

figure(2);
subplot(211), loglog(f, abs(Z(1:nR,:)));
title(['Betrag der Impedanz (mit R als Parameter, Rmin = ',...
    num2str(R(1)),' Ohm ;    Rmax = ', num2str(R(end)),'  Ohm)']);
xlabel('f/f0r,  (Relative Frequenz)');   grid on;


subplot(212), semilogx(f, angle(Z(1:nR,:))*180/pi);
title('Winkel der Impedanz');
xlabel('f/f0r,  (Relative Frequenz)');   grid on;
