% Skript ortsk_rlc_parallel1.m in dem eine Ortskurve
% fr das RLC-Parallelkreis berchnet und dargestellt wird

clear;

% ------- Parameter der Impedanz
C = 100e-12;
L = 20e-6;
% R und Omega werden als Parameter gewhlt

f0r = 1/(2*pi*sqrt(L*C));    % Resonanzfrequenz

f = logspace(-1, 1, 500);    % Relative Frequenz
f = sort([f,1]);% Hinzufgen der relativen Freq. 1

omega = 2*pi*f*f0r;          % Absolute Frequenz
nf = length(f);

R = 100:100:1000;            % Bereich fr R
nR = length(R);

Z = zeros(nR, nf);           % Initialisierungen
Y = Z;
for k = 1:nR
    Y(k,:) = 1./R(k) + 1./(j*omega*L) + j*omega*C;
end;
Z = 1./Y;

%####################################
figure(1);
plot(real(Z(1,:)), imag(Z(1,:)));
hold on
for k = 2:nR
    plot(real(Z(k,:)), imag(Z(k,:)));
end;
for k = 1:10:nf
    plot(real(Z(:,k)), imag(Z(:,k)));
    if (k > 150)& k<(nf-150),
        text(real(Z(end,k)), imag(Z(end,k)), num2str(f(k)));
    end;    
end;
hold off
grid on;
title('Ortskurve der Impedanz der RLC-Parallelschaltung');
xlabel('Ohm');
La = axis;    axis(La*1.1)

%####################################
% ------ Darstellung als Betrag und Winkel

figure(2);
subplot(211), loglog(f, abs(Z(1:nR,:)));
title(['Betrag der Impedanz (mit R als Parameter, Rmin = ',...
    num2str(R(1)),' Ohm ;    Rmax = ', num2str(R(end)),'  Ohm)']);
xlabel('f/f0r,  (Relative Frequenz)');   grid on;
ylabel('Ohm');

subplot(212), semilogx(f, angle(Z(1:nR,:))*180/pi);
title('Winkel der Impedanz');
xlabel('f/f0r,  (Relative Frequenz)');   grid on;
ylabel('Grad');
