% Skript mehrphas_1.m in dem die Spannungen eines 
% Mehrphasigen Systems dargestellt werden

clear;
% -------- Zweiphasiges Systems
uampl1 = 230*sqrt(2);
uampl2 = uampl1;
f = 50;
T = 1/f;

dt = T/100;    Tfinal = 5*T;

t = 0:dt:Tfinal;
u1 = uampl1*cos(2*pi*f*t);
u2 = uampl2*cos(2*pi*f*t - pi/2);

figure(1);   clf;
subplot(211), plot(t, u1, t, u2,'--');
title('Zweiphasiges System');
xlabel('Zeit in s');   grid on;

uampl3 = uampl2;
u1 = uampl1*cos(2*pi*f*t);
u2 = uampl2*cos(2*pi*f*t - 2*pi/3);
u3 = uampl2*cos(2*pi*f*t - 2*2*pi/3);

subplot(212), plot(t, u1, t, u2,'--', t, u3,'-.');
title('Dreiphasiges System');
xlabel('Zeit in s');   grid on;