% Skript leistungsfaktor_1.m in dem der
% Leistungsfaktor kompensiert wird

clear;
% ------- Parameter der Schaltung 
R1 = 1;      
f = 50;       omega = 2*pi*f;
U = 230;       % Effektivwert der Spannung 
               % fr die Spezifikation des Motors
P = 2000;             cos_phi = 0.82;
phi = acos(cos_phi);     % Positiv weil induktiv
% ------- Ersatzschaltung des Motors
Rm = U^2/P;
I = P/(U*cos_phi);
IL = I*sin(phi);
Lm = U/(omega*IL);
% ------- Kompensationskapazitt fr phi = 0
C = 1/(omega^2*Lm)
Ug = U;
Ig = Ug/(R1 + Rm)
% ------- Kompensationskapazitt fr cos_phi = 0,94
Cv = (0.2:0.01:1)*C;    % Bereich fr die Kapazitt C
Z = 1./(j*omega*Cv + 1/Rm + 1/(j*omega*Lm)); % Impedanz
           % als Funktion von C
cos_phi_neu = cos(angle(Z));
figure(1);   clf;
   plot(Cv, cos_phi_neu);
   title('cos-phi nach C');
   xlabel('C');    ylabel('cos-phi');
   hold on;
   La = axis;
   plot(La(1:2), [0.94, 0.94], 'r');
   hold off;
   grid on;
% Fr cos_phi = 0,94 erhlt man
C_neu = 4e-5
Z_neu = 1/(j*omega*C_neu + 1/Rm + 1/(j*omega*Lm));
Ig_neu = Ug/abs(R1 + Z_neu)