% Skript leistung_4.m 

clear;
% ------- Parameter der Schaltung
R1 = 100;      R2 = 80;
C = 500e-9;
f = 800;       omega = 2*pi*f;
Ug = 60;       % Effektivwert der Quelle

% ------ Aequivalente Impedanz der Quelle
Zi = R1*(R2 + 1/(j*omega*C))/(R1 + R2 + 1/(j*omega*C))
% ------ Aequivalente Spannung der Quelle
Ui = Ug*(R2 + 1/(j*omega*C))/(R1 + R2 + 1/(j*omega*C))

Ri = real(Zi);
Ci = -1/(imag(Zi)*omega);

L = 1/(omega^2*Ci)   % Reihenresonanz
XL  = omega*L

R3 = Ri             % Leistungsanpassung
Z3 = R3 + j*XL       % Optimaler Verbraucher
P3 = abs(Ui/(Zi + Z3))^2*R3