% Skript leistung_3.m 

clear;
% ------- Parameter der Schaltung
R1 = 100;      R2 = 80;
L = 30e-3;
f = 800;       omega = 2*pi*f;
Ug = 60;       % Effektivwert der Quelle

% ------ Aequivalente Impedanz der Quelle
Zi = R1*(R2 + j*omega*L)/(R1 + R2 + j*omega*L)
% ------ Aequivalente Spannung der Quelle
Ui = Ug*(R2 + j*omega*L)/(R1 + R2 + j*omega*L)

Ri = real(Zi);
Li = imag(Zi)/omega;

C = 1/(omega^2*Li)   % Reihenresonanz
Xc  = 1/(omega*C)

R3 = Ri             % Leistungsanpassung
Z3 = R3 -j*Xc       % Optimaler Verbraucher
P3 = abs(Ui/(Zi + Z3))^2*R3