% Skript leistung_1.m 

clear;
% ------- Parameter der Schaltung
P2 = 1000;   % Watt
omega = 2*pi*50;   
R1 = 2;      % Ohm
L1 = 10e-3;  % H
U2 = 220;    % V
cos_phi = 0.75;   % cos_phi
phi_2 = acos(cos_phi);

I = P2/(U2*cos_phi);       % Effektivwert des Zuleitungsstroms

IR2 = I*cos_phi;           % Effektivwert Der Stroms IR2
R2 = U2/IR2;

IL2 = sqrt(I^2 - IR2^2);    % Effektivstrom der Induktivitt L2
L2 = U2/(omega*IL2);

% ------- Komplexe Variablen
U2k = U2;          % Nullphase 0
IL2k = IL2*exp(-j*pi/2);
IR2k = IR2;
Ik = IR2k + IL2k;           % oder Ik = I*exp(-j*phi_2); 
U1k = U2k + Ik*R1 + j*omega*L1*Ik;
phi_1 = angle(U1k) - angle(Ik)


% ------- Leistungen
P1 = P2 + R1*I^2
S1 = abs(U1k)*I
Q1 = abs(U1k)*I*sin(phi_1)
phi_1_grad = phi_1*180/pi