% Skript lambda_kom1.m in dem mit einem Kondensator
% der Leistungsfaktor eines Verbrauchers kompensiert wird

clear;

% ------- Parameter des Verbrauchers
f = 50;          % 50 Hz
omega = 2*pi*f;
R = 10;    L = 0.05;

% ------- Leistungsfaktor vor der Kompensation
phi_uis = atan2(omega*L, R);  % Anfangsphasenverschiebung phi_u-phi_i
lambda_1 = cos(phi_uis);      % Anfangsleistungsfaktor

% ------- Leistungsfaktor kompensiert mit C
lambda_id = 0.8;              % Idealer leistungsfaktor
%C = (0.1:0.1:1000)*1.e-6;
C = logspace(-7, -3, 500);    % Bereich fr C
nc = length(C);

phi_ui = atan2(omega*L,R) - atan2(omega*R*C, 1-omega^2*L*C);
         % Phasenverschiebung mit C zugeschaltet
lambda_C = cos(phi_ui);     % Leistungsfaktor nach C

figure(1);
semilogx(C, lambda_C);
title('Funktion  \lambda(C)')
xlabel('Kapazitaet in F')
ylabel('Leistungsfaktor');   grid on;
hold on
La = axis;   
plot([La(1), La(2)], [lambda_id, lambda_id],'r');
hold off

figure(2);
semilogx(C, phi_ui*180/pi);
title('Phasenverschiebung der Spannung relativ zum Strom als Funktion von C');
xlabel('Kapazitaet in F')
ylabel('Grad');   grid on;

text(1e-5, 25, 'Induktiv');
text(2e-4, 25, 'Kapazitiv');





