% Skript freqg_RLC1.m in dem der Frequenzgang
% der RLC-Reihenschaltung mit Ausgang auf C
% ermittelt und dargestellt wird

clear;

% ------- Parameter der Schaltung
L = 10e-6;
C = 120e-12;

% ------- Resonanzfrequenz
f0r = 1/(2*pi*sqrt(L*C))

a1 = round(log10(f0r/100));
a2 = round(log10(f0r*100));

f = logspace(a1, a2, 500);   % Frequenzbereich
omega = 2*pi*f;
nf = length(f);

R = 100:200:900;  % Bereich fr R
nr = length(R);

H = zeros(nr,nf); % Komplexer Frequenzgang 
                  % (Uc(jomega)/Ug(jomega))
for k = 1:nr
    H(k,:) = 1./((1 - omega.^2*L*C) + j*omega*R(k)*C);
end;

figure(1);
subplot(211), semilogx(f, abs(H)');
title('Amplitudengang');
xlabel('Frequenz in Hz');   grid on;
hold on;
La = axis;   
semilogx([f0r, f0r], [La(3), La(4)],'r');
hold off;

subplot(212), semilogx(f, angle(H)'*180/pi);
title('Phasengang');
xlabel('Frequenz in Hz');   grid on;
ylabel('Grad');
hold on;
La = axis;   
semilogx([f0r, f0r], [La(3), La(4)],'r');
hold off;

