% Skript erz_verbr_1.m in dem eine einfache 
% Erzeuger-Verbraucher Schaltung untersucht wird
clear;
% ------- Parameter der Schaltung
Rl = 0.1;    Ll = 0.001;
Rs = 10;     Ls = 0.1;
Ug = 230;
f = 50;      omega = 314;
% ------- Leistungsfaktor des Verbrauchers
phi = atan(omega*Ls/Rs);
phi_g = phi*180/pi;
lambda = cos(phi);    % Leistungsfaktor
% ------- Strom und Spannung des Verbrauchers
I = Ug/(Rl + Rs + j*omega*(Ll + Ls));
Ieff = abs(I);
Us = I*(Rs + j*omega*Ls);
Useff = abs(Us);
% ------- Leistungen beim Verbraucher
Ps = Ieff*Useff*lambda;    %(oder Ieff^2*Rs)
Qs = Ieff*Useff*sin(phi);  %(oder Ieff^2*omega*Ls)
% ------- Leistungen beim Erzeuger
Pg = Ps + Ieff^2*Rl;
Qg = Qs + Ieff^2*omega*Ll;
% ------- Ergebnise
disp(['Ieff = ', num2str(Ieff),' A'])
disp(['Useff = ', num2str(Useff),' V'])
disp(['Ps = ', num2str(Ps),' W'])
disp(['Qs = ', num2str(Qs),' VAr'])
disp(['Pg = ', num2str(Pg),' W'])
disp(['Qg = ', num2str(Qg),' VAr'])







