% Skript dreiphasen_1.m in dem ein Dreiphasensystem
% mit unsymmetrischer Belastung geloest wird

clear;
% ------- Parameter der Schaltung
f = 50;    omega = 314;
UY = 230;

P1 = 18000;    I1 = P1/UY;      R1 = UY/I1;

S2 = 23000;
cos_phi = 0.8;          sin_phi = sqrt(1-cos_phi^2);
I2 = S2/(UY*sin_phi);

R2 = UY*cos_phi/I2;     L2 = UY*sin_phi/(omega*I2);

P3 = 10000;       R3 = UY^2/P3;       C3 = 200e-6;
IR3 = P3/UY;
IC3 = UY*omega*C3;
I3 = sqrt(IR3^2 + IC3^2);
phi_3 = atan2(IC3, IR3)

Z1 = R1;       % Impedanz Strang 1
Z2 = R2 + j*omega*L2;       % Impedanz Strang 2
Z3 = R3*(1/(j*omega*C3))/(R3 + 1/(j*omega*C3));
U1 = UY;                  % Strangspannung 1 (Referenz)
U2 = UY*exp(-j*2*pi/3);   % Strangspannung 2 
U3 = UY*exp(j*2*pi/3);    % Strangspannung 3

Uv = [U1; U2; U3; 0];
Z = [Z1 0 0 -1; 
     0 Z2 0 -1; 
     0 0 Z3 -1; 
     1 1  1 0];
% ------- Loesung der Matrixgleichung
y = inv(Z)*Uv;

I1k = y(1)   % Strangstrom 1 
I2k = y(2)   % Strangstrom 2 
I3k = y(3)   % Strangstrom 3 
UNk = y(4)   % Spannung der Sternmitte

I1 = abs(I1k)
phi_1 = angle(I1k)*180/pi

I2 = abs(I2k)
phi_2 = angle(I2k)*180/pi

I3 = abs(I3k)
phi_3 = angle(I3k)*180/pi

UN = abs(UNk)
phi_UN = angle(UNk)*180/pi