% Skript dreiphasen_0.m in dem ein Dreiphasensystem
% mit unsymmetrischer Belastung geloest wird

clear;
% ------- Parameter der Schaltung
f = 50;    omega = 314;
UY = 230;

P1 = 18000;
I1 = P1/UY;
R1 = UY/I1;

S2 = 23000;
cos_phi = 0.8;          sin_phi = sqrt(1-cos_phi^2);
I2 = S2/(UY*sin_phi);

R2 = UY*cos_phi/I2;
L2 = UY*sin_phi/(omega*I2);

P3 = 10000;
R3 = UY^2/P3;
C3 = 200e-6;
IR3 = P3/UY;
IC3 = UY*omega*C3;
I3 = sqrt(IR3^2 + IC3^2);
phi_3 = atan2(IC3, IR3)

Z1 = R1;       % Impedanz Strang 1
Z2 = R2 + j*omega*L2;       % Impedanz Strang 2
Z3 = R3*(1/(j*omega*C3))/(R3 + 1/(j*omega*C3));      
                            % Impedanz Strang 3
U1k = UY;                  % Strangspannung 1 (Referenz)
U2k = UY*exp(-j*2*pi/3);   % Strangspannung 2 
U3k = UY*exp(j*2*pi/3);    % Strangspannung 3

I1k = U1k/Z1;   I1 = abs(I1k)
I2k = U2k/Z2;   I2 = abs(I2k)
I3k = U3k/Z3;   I3 = abs(I3k)

INk = I1k + I2k + I3k; % Nullleitungstrom
IN = abs(INk)
phi_N = angle(INk)*180/pi

figure(1);   clf;
title('Spannungen und Stroeme der Sternschaltung')
compass(U1k);
hold on;
compass(U2k);
compass(U3k);

compass(I1k, 'r');
compass(I2k, 'r');
compass(I3k, 'r');
compass(INk,'--');
hold off;