% Skript drehfeld_3phasig1.m in dem das Entstehen eines 
% Drehfeldes simuliert wird.

clear;
% ------ Erzeugung der drei Fleder
ampl = 5;
f = 50;
T = 1/f;

dt = 1e-3;
t = 0:dt:5*T;
nt = length(t);

B1 = ampl*cos(2*pi*f*t); 
B2 = ampl*cos(2*pi*f*t - 2*pi/3);
B3 = ampl*cos(2*pi*f*t - 2*2*pi/3);

Br = B1 + B2*cos(2*pi/3) + B3*cos(4*pi/3);
Bi = 0 +  B2*sin(2*pi/3) + B3*sin(4*pi/3);
radius = max(sqrt(Br.^2 + Bi.^2));

close all
% ------ Darstellung der Induktionen als Vektoren
for k = 1:1:nt; 
    plot([-10,10], [0,0],'r');
    hold on
    plot([0,0], [-10,10],'r');
    plot(radius*exp(j*(0:0.1:2*pi)));
    
    axis([-10,10,-10,10]);
    quiver(0,0,ampl*cos(2*pi*f*t(k)), 0,'Linewidth', 3);
    quiver(0,0,ampl*cos(2*pi*f*t(k) - 2*pi/3)*cos(2*pi/3), ...
        ampl*cos(2*pi*f*t(k) - 2*pi/3)*sin(2*pi/3),'Linewidth', 3);
    quiver(0,0,ampl*cos(2*pi*f*t(k) - 4*pi/3)*cos(4*pi/3), ...
        ampl*cos(2*pi*f*t(k) - 4*pi/3)*sin(4*pi/3),'Linewidth', 3);
    
    quiver(0,0,ampl*cos(2*pi*f*t(k))+ampl*cos(2*pi*f*t(k) - 2*pi/3)*cos(2*pi/3)+...
        ampl*cos(2*pi*f*t(k) - 4*pi/3)*cos(4*pi/3),...
        0+ampl*cos(2*pi*f*t(k) - 2*pi/3)*sin(2*pi/3)+...
        ampl*cos(2*pi*f*t(k) - 4*pi/3)*sin(4*pi/3),'Linewidth', 3);
    grid on;
    hold off;
    M(k) = getframe;
end;    
% movie(M);

figure(2);   clf;
plot(t,B1, t,B2, t,B3);
title('Drei Induktionen mit 120 Grad phasenverschoben');
xlabel('Zeit in s');   grid on;

figure(3);   clf;
subplot(211), plot(t, Br);
title('Projektion der gesamten Induktion auf der Realachse');
xlabel('Zeit in s');    grid on;

subplot(212), plot(t, Bi);
title('Projektion der gesamten Induktion auf der Imaginaerachse');
xlabel('Zeit in s');    grid on;
