% Skript drehfeld_2phasig1.m in dem das Enstehen des
% Drehfeldes eines zweiphasigen Systems erlutert wird

clear;
% ------- Zeitvariable
dt = 0.002;
t = 0:dt:0.1;
nt = length(t);

f = 50;
B_ampl = 1;      % Amplitude der Feldstrke einer Wicklung

nx = 200;
x = linspace(0, 2*pi, nx);        % Umfang Schritte

B1 = zeros(nx, nt);   B2 = B1;
% Matrizen der Feldstrken: 
% In den Zeilen sind die Feldstrken als Zeitfunktionen
% fr verschiedene Stellen entlang des Umfangs

for k = 1:nx
    B1(k,:) = B_ampl*cos(2*pi*f*t)*sin(x(k));
    B2(k,:) = B_ampl*cos(2*pi*f*t-pi/2)*sin(x(k)-pi/2);
end;  
% B1 = Feldstrke 1 als Zeit- und Raumfunktion
% B2 = Feldstrke 2 als Zeit- und Raumfunktion

B = B1 + B2;   % Drehfeld  

%############################
figure(1);   clf;
nd = 1:fix(nt/2);
ndl = length(nd);

subplot(311), 
plot(x, B1(:,nd),'LineWidth', 0.05);
       % Darstellung der Spalten der Matrix B1
title(['Feldstaerke der Wicklung 1 fuer ', num2str(ndl),...
    '  Zeitmomente mit Abstand 2 ms']);
%xlabel('Umfang in Rad');    
grid on;
axis tight;

hold on;    % Markierung der Wicklungen
plot([0.05, pi], [0, 0], 'o', 'MarkerSize', 10, 'MarkerFaceColor','r' );
plot([pi/2, pi/2 + pi], [0, 0], 'x','MarkerSize', 10, ...
    'MarkerEdgeColor','r', 'LineWidth', 3);
hold off;

subplot(312),
plot(x, B2(:,nd),'LineWidth', 0.05);
       % Darstellung der Spalten der Matrix B2
title(['Feldstaerke der Wicklung 2 fuer ', num2str(ndl),...
    '  Zeitmomente mit Abstand 2 ms']);
%xlabel('Umfang in Rad');
grid on;
axis tight;

hold on;    % Markierung der Wicklungen
plot([0.05, pi], [0, 0], 'o', 'MarkerSize', 10, 'MarkerFaceColor','r' );
plot([pi/2, pi/2 + pi], [0, 0], 'x','MarkerSize', 10, ...
    'MarkerEdgeColor','r', 'LineWidth', 3);
hold off;

subplot(313), plot(x, B(:,nd),'LineWidth', 0.05);
       % Darstellung der Spalten der Matrix B
title(['Feldstaerke entlang der Umfangslinie fuer ',...
    ' Zeitschritte von 2 ms']);
xlabel('Umfang in Rad');   grid on;
axis tight;

hold on;    % Markierung der Wicklungen
plot([0.1, pi], [0, 0], 'o', 'MarkerSize', 10, 'MarkerFaceColor','r' );
plot([pi/2, pi/2 + pi], [0, 0], 'x','MarkerSize', 10, ...
    'MarkerEdgeColor','r', 'LineWidth', 3);
hold off;
