% Skript drehfeld_2phasig.m in dem das Enstehen des
% Drehfeldes eines zweiphasigen Systems erlutert wird

clear;
% ------- Zeitvariable
dt = 0.001;
t = 0:dt:0.1;
nt = length(t);

f = 50;
B_ampl = 1;      % Amplitude der Feldstrke einer Wicklung

B1 = B_ampl*cos(2*pi*f*t);        % Feldstrke 1 als Zeitfunktion
B2 = B_ampl*cos(2*pi*f*t - pi/2); % Feldstrke 2 als Zeitfunktion

nx = 200;
x = linspace(0, 2*pi, nx);        % Umfang Schritte

B = zeros(nx, nt);  % Matrix der Feldstrken 
    % In den Zeilen sind die Feldstrken fr 
    % verschiedene Stellen entlang des Unfangs

for k = 1:nx
    B(k,:) = B1*cos(x(k)) + B2*cos(x(k)-pi/2);
end;    
%############################
figure(1);
delta_t = 10;
nd = 1:delta_t;   % Zeitschritte fr das Drehfeld 

subplot(311), plot(t, B1);
title('Feldstaerke Wicklung 1')
xlabel('Zeit in s');    grid on;

subplot(312), plot(t, B2);
title('Feldstaerke Wicklung 2')
xlabel('Zeit in s');    grid on;

subplot(313), plot(x, B(:,nd));
title(['Feldstaerke entlang der Umfangslinie fuer ',...
    num2str(delta_t),' Zeitmomente von je 1 ms']);
xlabel('Umfang in Rad');   grid on;
axis tight;

hold on;    % Markierung der Wicklungen
plot([0.1, pi], [0, 0], 'o', 'MarkerSize', 10, 'MarkerFaceColor','r' );
plot([pi/2, pi/2 + pi], [0, 0], 'x','MarkerSize', 10, ...
    'MarkerEdgeColor','r', 'LineWidth', 3);
hold off;
