% Programm trafo_34.m in dem ein Transformator
% mit resistivem Verbraucher simuliert wird
% Transformator-Modell mit Gegeninduktivitt 

clear;

% ------- Parameter der T-Schaltung
N1 = 40;        N2 = N1;
Ls1 = 0.0001;   Ls2 = 0.0001;
Rw1 = 1;        Rw2 = 1;
L = 0.05;
Rg = 10;        R2 = 100;

% ------ Prameter der Schaltung mit M-Gegeninduktivitten
M = L;
L1 = Ls1 + L;   L2 = (Ls2 + L)*(N2/N1)^2;
k = M/sqrt(L1*L2)

% ------- Matrizen des Systems
Ai = [L1, M; M, L2];
Bi = [-(Rw1+Rg), 0; 0, -(Rw2+R2)];
Ci = [1, 0]';

% ------- Zustandsmatrizen A1, B1, C1, D1
E = inv(Ai);
A1 = E*Bi;
B1 = E*Ci;
C1 = eye(2);   D1 = [0, 0]';

% ------- Simulation mit Euler-Verfahren
f = 10000;
T = 1/f;             dt = T/200;
t = 0:dt:200*T;      nt = length(t);
ampl = 10;

%ug = ampl*cos(2*pi*f*t);   % Sinus-Anregung
ug = ampl*sign(cos(2*pi*f*t)); % Bipolare rechteckige Anregung
%ug = ampl*(sign(cos(2*pi*f*t))+1)/2; % Unipolare rechteckige

% Initialisierungen
i1 = zeros(1,nt);
i2 = i1;

ni = 100;
dti = dt/ni;
i1_temp = i1(1);
i2_temp = i2(1);
% ------ Euler-Verfahren (ohne Matrixform)
for k = 1:nt-1
    for p = 1:ni
        i1_temp =  dti*(A1(1,1)*i1_temp + A1(1,2)*i2_temp + ...
            B1(1)*ug(k)) + i1_temp;
        i2_temp = dti*(A1(2,1)*i1_temp + A1(2,2)*i2_temp + ...
            B1(2)*ug(k)) + i2_temp;
    end;
    i1(k+1) = i1_temp;
    i2(k+1) = i2_temp;
end;
im = i1 + i2;

figure(1);
nd = nt-1000:nt;
subplot(311), plot(t(nd), i1(nd), t(nd), ug(nd)/20);
  title('Strom i1 und ug/20');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), 1.1*La(3:4)]);
subplot(312), plot(t(nd), i2(nd));
  title('Strom i2');
  xlabel('Zeit in s');    grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3:4)]);
subplot(313), plot(t(nd), 20*im(nd));
  title('Strom im*20');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3:4)]);

Pg = mean(i1.*ug)       % Leistung von der Quelle
Pv = mean((i2.^2)*R2)   % Leistung beim Verbraucher

