% Programm trafo_2.m in dem ein Trafo
% mit kapazitiver Belastung im Zeitbereich
% untersucht wird

clear;
% ------- Parameter des Trafos
Ls1 = 0.0001;   Rw1 = 1;
Rw21 = 1;       Ls21 = 0.0001;
R21 = 100;      Rg = 10;
L = 0.05;       C = 0.05e-6;
%C = 0.01e-6

% ------- Matrizen des Systems
Ai = [Ls1, Ls21, 0; (Ls1+L), -L, 0; 0, 0, C];
Bi = [-(Rw1+Rg), -Rw21, -1; -(Rw1+Rg), 0, 0; 0, 1, -1/R21];
Ci = [1, 1, 0]';

% ------- Zustandsmatrizen A, B, C, D
E = inv(Ai);
A1 = E*Bi;
B1 = E*Ci;
C1 = eye(3);   D1 = [0, 0, 0]';

% ------- Simulation mit Euler-Verfahren
f = 10000;
T = 1/f;              dt = T/100;
t = 0:dt:1000*T;      nt = length(t);
ampl = 10;
ug = ampl*sign(sin(2*pi*f*t));
%ug = (ampl*sign(sin(2*pi*f*t)) + ampl)/2;
%ug = ampl*sin(2*pi*f*t);

% Initialisierungen
x = zeros(3,nt);   % x(1,:) = i1;
                   % x(2,:) = i2;
                   % x(3,:) = uc;
ni = 5;
dti = dt/ni;
x_temp = x(:,1);
for k = 1:nt-1
    for p = 1:ni
      x_temp = dti*(A1*x_temp + B1*ug(k)) + x_temp;
    end;
    x(:,k+1) = x_temp;
end;
im = x(1,:) - x(2,:);


figure(1);
nd = nt-500:nt-1;
subplot(411), plot(t(nd), x(1,nd), t(nd), ug(nd)/20);
title('Strom i1, ug/20');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), -0.6, 0.6]);
    
subplot(412), plot(t(nd), x(2,nd));
title('Strom i2');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), La(3:4)]);

subplot(413), plot(t(nd), im(nd));
title('Strom im');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), 1.2*min(im), 1.2*max(im)]);

subplot(414), plot(t(nd), x(3,nd));
title('Spannung uc');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), 1.2*min(x(3,:)), 1.2*max(x(3,:))]);

% ------- Simulation mit lsim
my_system = ss(A1,B1,C1,D1);
x_sim = lsim(my_system, ug',t');

im_sim = x_sim(:,1) - x_sim(:,2);

figure(2);
nd = nt-500:nt-1;
subplot(411), plot(t(nd), x_sim(nd,1), t(nd), ug(nd)/20);
title('Strom i1, ug/20');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), -0.6, 0.6]);

subplot(412), plot(t(nd), x_sim(nd,2));
title('Strom i2');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), La(3:4)]);

subplot(413), plot(t(nd), im_sim(nd));
title('Strom im');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), 1.2*min(im), 1.2*max(im)]);

subplot(414), plot(t(nd), x_sim(nd,3));
title('Spannung uc');
xlabel('Zeit in s');    grid on;
La = axis;   axis([t(nd(1)),t(nd(end)), 1.2*min(x(3,:)), 1.2*max(x(3,:))]);


