% Programm trafo_12.m in dem ein Trafo
% im Zeitbereich mit Euler-Verfahren simuliert wird

clear;
% ------- Parameter des Trafos
Ls1 = 0.0001;   Rw1 = 1;
Rw21 = 1;       Ls21 = 0.0001;
R21 = 100;
Rg = 10;
L = 0.05;
% ------- Matrizen des Systems
Ai = [(Ls1 + L), -L; L, -(L + Ls21)];
Bi = [-(Rw1+Rg) 0;0 (Rw21 + R21)];
Ci = [1 0]';

% ------- Zustandsmatrizen A, B, C, D
E = inv(Ai);
A = E*Bi;       B = E*Ci;
C = eye(2);     D = [0, 0]';

% ------- Simulation
fsig = 10000;
T = 1/fsig;          dt = T/200;
t = 0:dt:1000*T-dt;   nt = length(t);
u_ampl = 10;

% ug = u_ampl*(cos(2*pi*fsig*t)); % Sinusanregung
ug = u_ampl*sign(sin(2*pi*fsig*t)); % Bipolare Rechteckpulse
% ug = u_ampl*(sign(cos(2*pi*fsig*t))+1)/2; % Unipolare Rechteckpulse

% ------- Euler-Verfahren
i = zeros(2,nt);
i_temp = i(:,1);
ni = 3;
dti = dt/ni;
for k = 1:nt-1
    for p = 1:ni
       i_temp = i_temp + dti*(A*i_temp + B*ug(k));
    end;   
    i(:,k+1) = i_temp;
end;
im = i(1,:)-i(2,:);

nd = nt-1000:nt;  % Fr die Darstellung des
      % stationren Zustands
      
figure(1);
subplot(311), plot(t(nd), i(1,nd), t(nd), i(2,nd), t(nd), ug(nd)/50);
title('Strom i1, i2prim, ug/50');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);

subplot(312), plot(t(nd), im(nd));
title('Magnetisierungsstrom im');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);

subplot(313), plot(t(nd), i(2,nd)*R21);
title('Spannung am R21 (Ausgangsspannung)');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);

figure(2);
nd = nt-500:nt;  % Fr die Darstellung des
      % stationren Zustands
plot(t(nd), i(1,nd), t(nd), i(2,nd), t(nd), ug(nd)/50);
title('Strom i1, i2prim, ug/50');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);


