% Programm trafo_11.m in dem der Frequenzgang eines 
% Trafos ermittelt wird
clear;
% ------- Parameter des Trafos
Ls1 = 0.0001;   Rw1 = 1;
Rw21 = 1;       Ls21 = 0.0001;
R21 = 100;
Rg = 10;
L = 0.05;
% ------- Frequenzbereich
fmin = 10;      fmax = 500000;
a1 = floor(log10(fmin));      a2 = ceil(log10(fmax));
f = logspace(a1,a2,1000);
omega = 2*pi*f;
% ------- Frequenzgang
U21 = 1;
U1 = (U21/R21)*(Rw21 + j*omega*Ls21) + U21;
Ug = (U1./(j*omega*L) + U21/R21).*(Rg + Rw1 + j*omega*Ls1) + U1;
H = U21./Ug;   % Komplexer Frequenzgang
%-----------------------
figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
   title('Amplitudengang in dB');
   xlabel('Hz');     grid on;
subplot(212), semilogx(f, angle(H)*180/pi);
   title('Phasengang in Grad');
   xlabel('Hz');     grid on;
% -------- Antwort auf sinusfrmige Anregung im
% stationren Zustand (gem Frequenzgang)
fsig = 2e5;       u_ampl = 10;
omega_sig = 2*pi*fsig;
% ------- Frequenzgang fr dieses Signal
U21 = 1;
U1 = (U21/R21)*(Rw21 + j*omega_sig*Ls21) + U21;
Ug = (U1/(j*omega_sig*L) + U21/R21)*(Rg + Rw1 + j*omega_sig*Ls1) + U1;
Hsig = U21/Ug;   % Komplexer Frequenzgang

Tsig = 1/fsig;    dt = Tsig/100;
t = 0:dt:10*Tsig-dt;

ug = u_ampl*sin(2*pi*fsig*t);   % Anregung
u21 = u_ampl*abs(Hsig)*sin(2*pi*fsig*t + angle(Hsig));  % Ausgang

figure(2);    clf;
plot(t, ug, t, u21);
title('Antwort auf sinusfrmige Anregung im stationren Zustand');
xlabel('Zeit in s');   grid on;







