% Programm trafo_1.m in dem ein Trafo
% im Zeitbereich simuliert wird

clear;
% ------- Parameter des Trafos
Ls1 = 0.0001;   Rw1 = 1;
Rw21 = 1;        Ls21 = 0.0001;
R21 = 100;
Rg = 10;
L = 0.05;
% ------- Matrizen des Systems
Ai = [(Ls1 + L), -L; L, -(L + Ls21)];
Bi = [-(Rw1+Rg) 0;0 (Rw21 + R21)];
Ci = [1 0]';

% ------- Zustandsmatrizen A, B, C, D
E = inv(Ai);
A = E*Bi;       B = E*Ci;
C = eye(2);     D = [0, 0]';

% ------- Simulation
fsig = 10000;
T = 1/fsig;          dt = T/200;
t = 0:dt:1000*T-dt;   nt = length(t);
u_ampl = 10;

%ug = u_ampl*(cos(2*pi*fsig*t)); % Sinusanregung
ug = u_ampl*sign(sin(2*pi*fsig*t)); % Bipolare Rechteckpulse
%ug = u_ampl*(sign(cos(2*pi*fsig*t))+1)/2; %Unipolare Rechteckpulse
my_trafo = ss(A, B, C, D);

i = lsim(my_trafo, ug', t');   % Simulation mit lsim
im = i(:,1) - i(:,2);        % Magnetisierungsstrom

nd = nt-1000:nt;  % Fr die Darstellung des
      % stationren Zustands
figure(1);
subplot(311), plot(t(nd), i(nd,1), t(nd), i(nd,2), t(nd), ug(nd)/50);
title('Strom i1, i21, ug/50');
xlabel('Zeit in s');
grid on;
%La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);
La = axis;   axis([t(nd(1)), t(nt), 1.1*min([i(nd,1);i(nd,2);ug(nd)'/50]),...
    1.1*max([i(nd,1);i(nd,2);ug(nd)'/50])]);
legend('i1', 'i21', 'ug/50');

subplot(312), plot(t(nd), im(nd));
title('Magnetisierungsstrom im');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);

subplot(313), plot(t(nd), i(nd,2)*R21);
title('Spannung am R21 (Ausgangsspannung)');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);

figure(2);
nd = nt-500:nt;  % Fr die Darstellung des
      % stationren Zustands
plot(t(nd), i(nd,1), t(nd), i(nd,2), t(nd), ug(nd)/50);
title('Strom i1, i21, ug/50');
xlabel('Zeit in s');
grid on;
La = axis;   axis([t(nd(1)), t(nt), La(3:4)]);


