% Skript tastkopf_2.m in dem das Verhalten
% eines einfachen Tastkopfs mit Simulink-
% Modell (tastkopf2.mdl) untersucht wird

clear;
% ------- Parameter der Schaltung mit Tastkopf
Rg = 1000e3;     R1 = 9e6;     R2 = 1e6;
C2 = 100e-12;
C1 = 0.5*R2*C2/R1;   % Unterkompensiert
%C1 = R2*C2/R1;       % Kompensiert
%C1 = 1.5*R2*C2/R1;   % Ueberkompensiert
% ------- Matrizen des Zustandsmodells
A = [-(1/Rg+1/R1)/C1, -1/(Rg*C1); -1/(Rg*C2), -(1/Rg+1/R2)/C2];
B = [1/(Rg*C1); 1/(Rg*C2)];     C = [0, 1];    D = 0;
% ------- Koeffizienten der Uebertragungsfunktion
alpha = R2/(Rg + R1 + R2);
zaehler = alpha*[R1*C1, 1];
nenner = [alpha*R1*C1*Rg*C2, alpha*(R1*(C1+C2)+Rg*(C1*R1/R2+C2)), 1];

% ------- Anregung
f = 1e3;   % Frequenz der Eingangspulse
ampl = 2;  % Amplitudes der unipolaren Pulse

% ------- Aufruf der Simulation
sim('tastkopf2', [0, 5e-3]);
% y(:,1) = Anregung
% y(:,2) = Antwort des Stat-Space Blocks
% y(:,3) = Antwort des Transfer Fcn Blocks

figure(1);   clf;
subplot(211), plot(t, y(:,1));
title('Spannung der Quelle');
xlabel('Zeit in s');   grid on;
La = axis;  axis([La(1:2), La(3:4)*1.2])

subplot(212), plot(t, y(:,2));
title('Antwort des Tastkopfs');
xlabel('Zeit in s');   grid on;



