% Skript tastkopf_12.m in dem das Zeitverhalten
% eines einfachen Tastkopfs untersucht wird

clear;
% ------- Parameter der Schaltung mit Tastkopf
Rg = 1000e3;
R1 = 9e6;     R2 = 1e6;
C2 = 100e-12;

%C1 = 0.5*R2*C2/R1;   % Unterkompensiert
%C1 = R2*C2/R1;       % Kompensiert
%C1 = 1.5*R2*C2/R1;   % Ueberkompensiert
C1 = (R2*C2/R1)*[0.5, 1, 1.5];

figure(1);     clf;
ueberschrift = {['Unterkompensiert (C1 = ',num2str(C1(1)),')'],...
                ['Kompensiert (C1 = ',num2str(C1(2)),')'],...
                ['Ueberkompensiert (C1 = ',num2str(C1(3)),')']};

for k = 1:3
% ------- Matrizen des Zustandsmodells
    A = [-(1/Rg+1/R1)/C1(k), -1/(Rg*C1(k)); -1/(Rg*C2), -(1/Rg+1/R2)/C2];
    B = [1/(Rg*C1(k)); 1/(Rg*C2)];     C = [0, 1];    D = 0;

    my_ss = ss(A, B, C, D);  % Definition des Systems
    [st, t] = step(my_ss);   % Sprungantwort
    sprung{k} = st;          % Zwischenspeicherung
    zeit{k} = t;
end;

%########################
figure(1);    clf;
subplot(2,2,1), plot(zeit{1}, sprung{1});
title(['Sprungantwort  ', ueberschrift{1}]);  
xlabel('Zeit in s');    grid on;

subplot(2,2,2), plot(zeit{2}, sprung{2});
title(['Sprungantwort  ', ueberschrift{2}]);  
xlabel('Zeit in s');    grid on;

subplot(2,2,3), plot(zeit{3}, sprung{3});
title(['Sprungantwort  ', ueberschrift{3}]);  
xlabel('Zeit in s');    grid on;

zeiger = subplot(2,2,4);
set(zeiger, 'Visible', 'off'),
axis([1, 100 0 100]);     
text(5, 80, 'Tastkopf-Parameter');
text(5, 70, ['R1 = ',num2str(R1), ' Ohm']);
text(5, 60, ['R2 = ',num2str(R2), ' Ohm']);
text(5, 50, ['C2 = ',num2str(C2), ' F']);

text(5, 30, 'Quelle');
text(5, 20, ['Rg = ',num2str(Rg), ' Ohm']);
return






% ------- Koeffizienten der Uebertragungsfunktion
alpha = R2/(Rg + R1 + R2);
zaehler = alpha*[R1*C1, 1];
nenner = [alpha*R1*C1*Rg*C2, alpha*(R1*(C1+C2)+Rg*(C1*R1/R2+C2)), 1];

my_tf = tf(zaehler, nenner);
[st, t] = step(my_tf);

%########################
figure(2);     clf;
plot(t, st);
title('Sprungantwort');  
xlabel('Zeit in s');    grid on;
