% Skript tastkopf_1.m in dem das Zeit- und Frequenzverhalten
% eines einfachen Tastkopfs untersucht wird

clear;
% ------- Parameter der Schaltung mit Tastkopf
Rg = 1000e3;     R1 = 9e6;     R2 = 1e6;
C2 = 100e-12;
%C1 = 0.5*R2*C2/R1;   % Unterkompensiert
%C1 = R2*C2/R1;       % Kompensiert
C1 = 1.5*R2*C2/R1;   % Ueberkompensiert
% ------- Matrizen des Zustandsmodells
A = [-(1/Rg+1/R1)/C1, -1/(Rg*C1); -1/(Rg*C2), -(1/Rg+1/R2)/C2];
B = [1/(Rg*C1); 1/(Rg*C2)];     C = [0, 1];    D = 0;
% ------- Koeffizienten der Uebertragungsfunktion
alpha = R2/(Rg + R1 + R2);
zaehler = alpha*[R1*C1, 1];
nenner = [alpha*R1*C1*Rg*C2, alpha*(R1*(C1+C2)+Rg*(C1*R1/R2+C2)), 1];

my_ss = ss(A, B, C, D);            % Definitionen des Systems
my_tf = tf(zaehler, nenner);
[st_s, t] = step(my_ss);   % Sprungantwort
[st_tf, t] = step(my_tf);

%########################
figure(1);    clf;
subplot(211), plot(t, st_s);
title('Sprungantwort aus Zustandsmodell');  
xlabel('Zeit in s');    grid on;
subplot(212), plot(t, st_tf);
title('Sprungantwort aus Uebertragungsfunktion');  
xlabel('Zeit in s');    grid on;

% ------- Die Antwort auf rechteckige Signale mit lsim
f = 1e3;     T = 1/f;
dt = T/1000;
t = 0:dt:5*T-dt;
nt = length(t);
ug = sign(sin(2*pi*f*t));  % Rechteckiges Signal 
ua = lsim(my_ss, ug', t'); % Antwort
%ua = lsim(my_tf, ug', t');
figure(2);    clf;
subplot(211), plot(t, ug);
title('Rechteckige Signale der Quelle');
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:2), La(3:4)*1.2])
subplot(212), plot(t, ua);
title('Antwort auf rechteckige Signale');
xlabel('Zeit in s');   grid on;

% ------- Numerische Integration mit Euler-Verfahren
uc = zeros(2,nt);
uc(:,1) = [0,0];

n_intern = 10; % Anzahl Schritte die nicht gespeichert werden
uc_temp = uc(:,1);
for k = 1:nt-1
    for p = 1:n_intern
        uc_temp = uc_temp + dt*(A*uc_temp + B*ug(k))/n_intern;
    end;
    uc(:,k+1) = uc_temp;    % Der gespeicherte Wert
end;
ua_n = uc(2,:);
%########################
figure(3);     clf;
plot(t, ua_n, t, ua);
title(['Antwort auf rechteckige Signale mit  lsim und mit ',...
              'Euler-Verfahren']);
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:2), La(3:4)*1.2])

% -------- Frequenzgang der Schaltung von ug bis ua
fmin = 1e3;   % Ganze Potenzen von 10
fmax = 1e8;

f = logspace(3,7, 1000);   % 500 Frequenzwerte logarithmisch skaliert
omega = 2*pi*f;

Z1 = R1./(j*omega*R1*C1 + 1);
Z2 = R2./(j*omega*R2*C2 + 1);
Ua = 1;
Ug = (Ua./Z2).*(Rg + Z1)+Ua;
H = Ua./Ug;

figure(4);     clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang');
xlabel('Hz');   grid on;
subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang');
xlabel('Hz');   grid on;

% -------- Frequenzgang der Schaltung von ug bis ua
% mit freqs ermittelt
Hs = freqs(zaehler, nenner, omega);
figure(5);     clf;
subplot(211), semilogx(f, 20*log10(abs(Hs)));
title('Amplitudengang');
xlabel('Hz');   grid on;
subplot(212), semilogx(f, angle(Hs)*180/pi);
title('Phasengang');
xlabel('Hz');   grid on;






