% Skript strom_kond_1.m in dem aus gegebener Strom
% die Spannung eines Kondensators und die
% gespeicherte Energie berechnet werden

clear;
% ------ Parameter 
C = 5;

% ------ Verlauf des Stroms
dt = 0.01;
t = -1:dt:3;
u = ((10/2)*(t+1)).*(t<=1) + ...
      10*(t > 1).*(t <= 2) + ...
     (10-10*(t-2)).*(t > 2).*(t <= 3);

% ------ Spannung des Kondensators
i = cumsum(i)*dt/C;

% ------ Energie des Kondensators
w = C*u.^2/2;

figure(1);   clf;
subplot(311), plot(t, i);
title('Strom  des  Kondensators')
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:3), 11])

subplot(312), plot(t, u);
title('Spannung  des  Kondensators')
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, w);
title('Energie  des  Kondensators')
xlabel('Zeit in s');   grid on;