% Skript strom_induk_1.m in dem aus gegebener Spannung
% der Strom einer Induktivitt und die
% gespeicherte Energie berechnet werden


clear;
% ------ Parameter 
L = 5;

% ------ Verlauf des Spannung
dt = 0.01;
t = 0:dt:4;
u = 10.*(t<=1) + ...
    30*(t > 1).*(t <= 2) + ...
    20*(t > 2).*(t <= 3) + ...
    0*(t > 3).*(t <= 4);

% ------ Strom der Induktivitt
i = cumsum(u)*dt/L;

% ------ Energie der Induktivitt
w = L*i.^2/2;

figure(1);   clf;
subplot(311), plot(t, u);
title('Spannung  der  Induktivitaet')
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:2), 0, 35]);
ylabel('Volt');

subplot(312), plot(t, i);
title('Strom  der  Induktivitaet')
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:2), 0, 15]);
ylabel('A');

subplot(313), plot(t, w);
title('Energie  der  Induktivitaet')
xlabel('Zeit in s');   grid on;
ylabel('Watt.s');


