% Skript spannung_induk_1.m in dem aus gegebenen Strom
% die Spannung einer Induktivitt und die
% gespeicherte Energie berechnet werden


clear;
% ------ Parameter 
L = 5;

% ------ Verlauf des Stroms
dt = 0.01;
t = 0:dt:4;
i = ((10/2)*t).*(t<=2) + ...
      10*(t > 2).*(t <= 3) + ...
     (10-10*(t-3)).*(t > 3).*(t <= 4);

% ------ Spannung der Induktivitt
u = L*[0,diff(i)]/dt;

% ------ Energie der Induktivitt
w = L*i.^2/2;

figure(1);   clf;
subplot(311), plot(t, i);
title('Strom  der  Induktivitaet')
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:3), 11])

subplot(312), plot(t, u);
title('Spannung  der  Induktivitaet')
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, w);
title('Energie  der  Induktivitaet')
xlabel('Zeit in s');   grid on;