% Skript oszillat_3.m in dem ein Oszillator mit
% Parallelresonanzkreis untersucht wird

clear;
% ------ Parameter der Schaltung
R1 = 10000;    R2 = 10000;
R12 = R1*R2/(R1 + R2);
L = 200e-6;    C = 500e-12;

alpha = 1.25;
A = alpha*(R1 + R2)/R1;
iL0 = 1e-3;       uc0 = 1;
f0rp = 1/(2*pi*sqrt(L*C));
T0 = 1/f0rp;

% ------ Numerische Integration
dt = T0/10000;
Tfinal = 25*T0;
t = 0:dt:Tfinal;

nt = length(t);
iL = zeros(1,nt);    uc = zeros(1,nt);

uout = zeros(1,nt);
iL(1) = iL0;         uc(1) = uc0;
u_OPmax = 12;        % Sttigungsspannung des OPs

for k = 1:nt-1
    uc(k+1) = uc(k) + dt*(-uc(k)/R12 - iL(k) + uout(k)/R2)/C;
    iL(k+1) = iL(k) + dt*(uc(k+1))/L;
    uout(k+1) = A*uc(k+1);
    if abs(uout(k+1)) >= u_OPmax   % Sttigung Abfrage 
        uout(k+1) = sign(uout(k+1))*u_OPmax;
    end;    
end;

figure(1);    clf;
subplot(211), plot(t, uc);
title(['Spannung uc(t)']); 
xlabel('Zeit in s');  grid on;

subplot(212), plot(t, uout);
title(['Spannung am Ausgang des OPs uout(t)  fr A = alpha*Aopt (alpha = ',...
    num2str(alpha),' )']); 
xlabel('Zeit in s');  grid on;
