% Skript oszillat_1.m in dem ein Oszillator mit
% Reihenresonanzkreis untersucht wird

clear;
% ------ Parameter der Schaltung
R1 = 1000;       R2 = 1000;
C = 500e-12;    L = 200e-6;

alpha = 1.02;
%alpha = 0.99;
Aopt = alpha*(R1 + R2)/R1;  % Optimale Verstrkung
iL0 = 1e-3;    uc0 = 1;     % Anfangsbedingungen
f0rh = 1/(2*pi*sqrt(L*C));  % Reihenresonanzfrequenz
T0 = 1/f0rh;                % Periode der Resonanzschwingung

% ------ Numerische Integration
dt = T0/1000;     Tfinal = 10*T0;
t = 0:dt:Tfinal;

nt = length(t);
iL = zeros(1,nt);    uc = zeros(1,nt); % Initialisierungen
iL(1) = iL0;         uc(1) = uc0;
for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(-iL(k)*(R2 + R1*(1-Aopt)) - uc(k))/L;
    uc(k+1) = uc(k) + dt*(iL(k+1))/C;
end;
ub = iL*R1;        % Eingangsspannung Schaltung mit OP
uausg = ub*Aopt;   % Ausgangsspannung OP
%###########

figure(1);    clf;
plot(t, uc, t, ub, t, uausg);
title(['Spannungen uc, ub und uausg ( A = ',...
    num2str(alpha),'*Aopt)']); 
xlabel('Zeit in s');  grid on;
legend('uc', 'ub', 'uausg');

