% Skript mos_inv4.m in dem die Verbindung zwischen
% einem CMOS-Inverter mit Cgs Belastung untersucht wird

clear;
% ------ Parameter der Schaltung
Ron1 = 500;
Ron2 = 500;
Cgs = 0.005e-12;
UD = 1;
% ------ Modell fr MOS blockiert
% uc(t+dt) = uc(t) + dt*(UD-uc(t))/(Ron1*Cgs)

% ------ Modell fr Inverter leitend
% uc(t+dt) = uc(t) + dt*(- uc(t))/(R0n2*Cgs)

% ------ Simulation mit Euler-Verfahren
fst = 1000e6;       % Frequenz der rechteckigen Pulse
Tst = 1/fst;

dt = Tst/5000;
t = 0:dt:5*Tst;    nt = length(t);

us = sign(sin(2*pi*fst*t));
uc = zeros(1,nt);
iR1 = zeros(1,nt);    iR2 = zeros(1,nt);

% ------ Euler Verfahren
for k = 1:nt-1
    uc(k+1) = (us(k) > 0)* (uc(k) + dt*(UD - uc(k))/(Ron1*Cgs)) + ...
              (us(k) <= 0)* (uc(k) + dt*(- uc(k))/(Ron2*Cgs));
    iR1(k+1) = (us(k) > 0)*(UD - uc(k+1))/Ron1 + (us(k) <= 0)*0;   
    iR2(k+1) = (us(k) > 0)*0 + (us(k) <= 0)*uc(k+1)/Ron2; 
end;

figure(1);    clf;
subplot(411), plot(t, us);
title('Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(412), plot(t, uc);
title('Gate-Source Spannung (Kapazittspannung)');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(413), plot(t, iR1);
title('Strom durch R1');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(414), plot( t, iR2);
title('Strom durch R2');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

% ------- Dissipierte Leistungen
nd = 1:nt(end);

PR1 = mean(iR1(nd).^2)*Ron1
PR2 = mean(iR2(nd).^2)*Ron2
PR1 + PR2

% ------- Ideale Leistungen
Pdynamik = (UD^2)*Cgs*fst
