% Skript mos_inv3_1.m in dem die Verlustleistung
% einer RC-Reihenschaltung untersucht wird

clear;
% ------ Parameter der Schaltung
R = 10000;
C = 0.003e-12;   % Fr RC << T1, T2
%C = 0.8e-12;    % Fr RC >> T1, T2

Ug = 5;      % Anregungsspannung
% ------ Modell fr Intervall T1
% uc(t+dt) = uc(t) + dt*(Ug-uc(t))/(R*C)
% ------ Modell fr Intervall T2
% uc(t+dt) = uc(t) + dt*(- uc(t))/(R*C)

% ------ Simulation mit Euler-Verfahren
f = 1000e6;       % Frequenz der rechteckigen Pulse
%f = 2000e6;       % Frequenz der rechteckigen Pulse
T = 1/f;
dt = T/5000;
t = 0:dt:50*T;    nt = length(t);

schwelle = 0.6;  % Schwelle mit der man das Tastverhltnis steuern kann
ug = Ug*(sign(sin(2*pi*f*t)-schwelle)+1)/2;
uc = zeros(1,nt);
iR = zeros(1,nt);    
% ------ Euler Verfahren
for k = 1:nt-1
    uc(k+1) = (ug(k) > 0)* (uc(k) + dt*(Ug - uc(k))/(R*C)) + ...
              (ug(k) <= 0)* (uc(k) + dt*(- uc(k))/(R*C));
end;
iR = (ug - uc)/R;

nd = nt(end) - 25000:nt(end);
figure(1);    clf;
subplot(311), plot(t(nd), ug(nd));
title('Anregungsspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3)-0.1*La(4), 1.2*La(4)]);

subplot(312), plot(t(nd), uc(nd));
title('Spannung der Kapazitt');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 0, 1.2*La(4)]);

subplot(313), plot(t(nd), iR(nd));
title('Strom durch R');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

% ------- Dissipierte Leistungen
P = mean(iR(nd).^2)*R

