% Skript mos_inv3.m in dem die Verbindung zwischen
% zwei MOS-Inverter untersucht wird

clear;
% ------ Parameter der Schaltung
R1 = 10000;
Ron = 500;
Cgs = 0.005e-12;
UD = 1;
Re = R1*Ron/(R1 + Ron);

% ------ Modell fr MOS blockiert
% uc(t+dt) = uc(t) + dt*(UD-uc(t))/(R1*Cgs)

% ------ Modell fr Inverter leitend
% uc(t+dt) = uc(t) + dt*(UD*Ron/(R1 + Ron) - uc(t))/((R1||Ron)*Cgs)

% ------ Simulation mit Euler-Verfahren
fst = 1000e6;       % Frequenz der rechteckigen Pulse
Tst = 1/fst;

dt = Tst/5000;
t = 0:dt:5*Tst;    nt = length(t);

us = sign(sin(2*pi*fst*t));    % Steuerspannung
uc = zeros(1,nt);
iR1 = zeros(1,nt);    iRon = zeros(1,nt);

% ------ Euler Verfahren
for k = 1:nt-1
    uc(k+1) = (us(k) > 0)* (uc(k) + dt*(UD - uc(k))/(R1*Cgs)) + ...
             (us(k) <= 0)* (uc(k) + dt*(UD*Ron/(R1+Ron) - uc(k))/(Re*Cgs));
    iR1(k+1) = (UD - uc(k+1))/R1;   
    iRon(k+1) = (us(k) > 0)*iR1(k+1) + (us(k) <= 0)*uc(k+1)/Ron; 
end;

figure(1);    clf;
subplot(411), plot(t, us);
title('Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(412), plot(t, uc);
title('Gate-Source Spannung (Kapazittspannung)');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(413), plot(t, iR1);
title('Strom durch R1');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3)-0.1*La(4), 1.2*La(4)]);

subplot(414), plot( t, iRon);
title('Strom durch Ron');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3)-0.1*La(4), 1.2*La(4)]);

% ------- Dissipierte Leistungen
nd = 2000:nt(end);

PR1 = mean(iR1(nd).^2)*R1
PR2 = mean(iRon(nd).^2)*Ron
PR1 + PR2

% ------- Ideale Leistungen
Pdynamik = UD^2*Cgs*fst
Pstatik = UD^2/(2*R1)
Pdynamik + Pstatik