% Skript mos_inv2.m in dem die Verbindung zwischen
% zwei MOS-Inverter untersucht wird

clear;
% ------ Parameter der Schaltung
R1 = 1000;
R2 = 100;
L = 0.001e-6;
Cgs = 0.05e-12;
Ug = 5;

% ------ Modell fr Inverter blockiert
A11 = [-R1/L -1/L;1/Cgs 0];
B11 = [1/L 0]';

% ------ Modell fr Inverter leitend
R12 = R1*R2/(R1 + R2);
A12 = [-R12/L -1/L;1/Cgs 0];
B12 = [R2/(L*(R1 + R2)) 0]';



% ------ Simulation mit Euler-Verfahren
fst = 1000e6;       % Frequenz der rechteckigen Pulse
Tst = 1/fst;

dt = Tst/5000;
t = 0:dt:5*Tst;    nt = length(t);

us = sign(sin(2*pi*fst*t));
x = zeros(2,nt);   % x(1,:) = iL,   x(2,:) = uc
x_temp = x(:,1);
iR1 = zeros(1,nt);


% ------ Euler Verfahren
for k = 1:nt-1
    x_temp = (us(k) > 0)* (x_temp + dt*(A11*x_temp + B11*Ug))+...
             (us(k) <= 0)*(x_temp + dt*(A12*x_temp + B12*Ug));
    iR1(k+1) = (us(k) > 0)*x_temp(1) +...
               (us(k) <= 0)*(Ug - x_temp(2) - L*(A12(1,1)*x_temp(1) + A12(1,2)*x_temp(2) + B12(1)*Ug))/R1;         
    x(:,k+1) = x_temp;
end;
iR2 = iR1 - x(1,:);

figure(1);    clf;
subplot(411), plot(t, us);
title('Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(412), plot(t, x(2,:));
title('Gate-Source Spannung (Kapazittspannung)');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(413), plot(t, x(1,:));
title('Strom der Kapazitt');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(414), plot( t, iR1, t, iR2);
title('Strom durch R1 und R2');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

% ------- Wurzeln der charakteristischen Gleichung
% fr MOS blockiert
lambda_1 = eig(A11)
sigma_1 = real(lambda_1)
omega_01 = imag(lambda_1)/(2*pi)

% fr MOS leitend
lambda_2 = eig(A12)
sigma_2 = real(lambda_2)
omega_02 = imag(lambda_2)/(2*pi)

% ------- Theoretische Wurzeln
lambda_id11 = -R1/(2*L)+j*sqrt(1/(L*Cgs) - (R1/(2*L))^2)
lambda_id12 = -R1/(2*L)+j*sqrt(1/(L*Cgs) - (R1/(2*L))^2)
         
lambda_id21 = -R2/(2*L)+j*sqrt(1/(L*Cgs) - (R2/(2*L))^2)
lambda_id22 = -R2/(2*L)+j*sqrt(1/(L*Cgs) - (R2/(2*L))^2)

% ------- Dissipierte Leistungen
nd = 2000:nt(end);

PR1 = mean(iR1(nd).^2)*R1
PR2 = mean(iR2(nd).^2)*R2
PR1 + PR2

% ------- Ideale Leistungen
Pdynamik = Ug^2*Cgs*fst
Pstatik = Ug^2/(2*R1)
Pdynamik + Pstatik