% Skript mos_inv1.m in dem die Verbindung zwischen
% zwei MOS-Inverter untersucht wird

clear;
% ------ Parameter der Schaltung
R1 = 1000;
R2 = 150;
L = 0.002e-6;
Cgs = 0.05e-12;
Ug = 5;

% ------ Modell fr Inverter blockiert
A11 = [-R1/L -1/L;1/Cgs 0];
B11 = [1/L 0]';

% ------ Modell fr Inverter leitend
A12 = [-R2/L -1/L;1/Cgs 0];
B12 = [0 0]';



% ------ Simulation mit Euler-Verfahren
fst = 1000e6;       % Frequenz der rechteckigen Pulse
Tst = 1/fst;

dt = Tst/1000;
t = 0:dt:5*Tst;    nt = length(t);

us = sign(sin(2*pi*fst*t));
x = zeros(2,nt);   % x(1,:) = iL,   x(2,:) = uc
x_temp = x(:,1);


% ------ Euler Verfahren
for k = 1:nt-1
    x_temp = (us(k) > 0)*(x_temp + dt*(A11*x_temp + B11*Ug))+...
             (us(k) <= 0)*(x_temp + dt*(A12*x_temp));
    x(:,k+1) = x_temp;
end;

figure(1);    clf;
subplot(311), plot(t, us);
title('Steuerspannung');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(312), plot(t, x(2,:));
title('Gate-Source Spannung des gesteurten Inverters');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

subplot(313), plot(t, x(1,:));
title('Strom des ersten Inverters');
xlabel('Zeit in s');    grid on;
La = axis;   axis([La(1:2), 1.2*La(3:4)]);

% ------- Wurzeln der charakteristischen Gleichung
% fr MOS blockiert
lambda_1 = eig(A11)
sigma_1 = real(lambda_1)
omega_01 = imag(lambda_1)/(2*pi)

% fr MOS leitend
lambda_2 = eig(A12)
sigma_2 = real(lambda_2)
omega_02 = imag(lambda_2)/(2*pi)

% ------- Theoretische Wurzeln
lambda_id11 = -R1/(2*L)+j*sqrt(1/(L*Cgs) - (R1/(2*L))^2)
lambda_id12 = -R1/(2*L)+j*sqrt(1/(L*Cgs) - (R1/(2*L))^2)
         
lambda_id21 = -R2/(2*L)+j*sqrt(1/(L*Cgs) - (R2/(2*L))^2)
lambda_id22 = -R2/(2*L)+j*sqrt(1/(L*Cgs) - (R2/(2*L))^2)
