% Skript inv_switch1.m in dem ein DC-DC invertierendes
% Schaltnetzteil simuliert wird

clear;
% ------- Parameter der Schaltung
fschalt = 20000;     % 20 kHz

Tschalt = 1/fschalt;
tastv = 0.5;

L = 20e-3;
C = 5000e-6;
Rg = 0.1;
Rs = 2;
Ug = 10;

% ------- Schaltspannung
dt = Tschalt/10;
t = 0:dt:2000*Tschalt;
nt = length(t);

us = sign(cos(2*pi*fschalt*t));

% ------- Numerische Lsung
iL = zeros(1,nt);
uc = zeros(1,nt);
kimax = 10;

iL_temp = iL(1);    % Anfangsbedingungen
uc_temp = uc(1);
for k = 1:nt-1
    for ki = 1:kimax    % Interne Iterationen
      if us(k) >= 0 % Schalter geschlossen, Diode blockiert
        iL_temp = iL_temp + (dt/kimax)*(Ug-iL_temp*Rg)/L;
        uc_temp = uc_temp + (dt/kimax)*(-uc_temp/Rs)/C;
      else          % Schalter geoeffnet, Diode leitend 
        iL_temp = iL_temp + (dt/kimax)*uc_temp/L;
        uc_temp = uc_temp + (dt/kimax)*(-uc_temp/Rs - iL_temp)/C;
      end;
    end;  
    iL(k+1) = iL_temp;
    uc(k+1) = uc_temp;
end;
ic = (-uc/Rs).*(us >= 0) + ...
    (-uc/Rs-iL).*(us < 0); % Strom im Kondensator
iD = -ic - uc/Rs;

% ------- Darstellungen
figure(1);    clf;
subplot(411), plot(t, iL);
title('Strom iL');  
xlabel('Zeit in s');   grid on;

subplot(412), plot(t, uc);
title('Spannung uc');  
xlabel('Zeit in s');   grid on;

subplot(413), plot(t, iD);
title('Strom iD');  
xlabel('Zeit in s');   grid on;

subplot(414), plot(t, ic);
title('Strom ic');  
xlabel('Zeit in s');   grid on;



% ------- Ausschnitt im stationaeren Zustand
nd = nt-200:nt;
figure(2);    clf;
subplot(411), plot(t(nd), iL(nd));
title('Strom iL (Ausschnitt aus dem stationren Zustand)');  
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1), t(nt), La(3:4)])

subplot(412), plot(t(nd), uc(nd));
title('Spannung uc (Ausschnitt aus dem stationren Zustand)');  
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1), t(nt), La(3:4)])

subplot(413), plot(t(nd), iD(nd));
title('Strom iD (Ausschnitt aus dem stationren Zustand)');  
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1), t(nt), La(3:4)])

subplot(414), plot(t(nd), ic(nd));
title('Strom ic (Ausschnitt aus dem stationren Zustand)');  
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1), t(nt), La(3:4)])


        
        
