% Skript aufgabe_5.m in dem ein RLC-Netzwerk
% mit sinusfrmiger Anregung untersucht wird

clear;
% ------- Parameter
R2 = 3;         % Widerstand
L = 5;     % Induktivit?t
Cc = 100.e-6;   % Kapazitt

ug2_ampl = 5;   % Amplitude Anregung
phi = pi/3;     % Nullphase
f = 1;       % Frequenz in Hz
omega = 2*pi*f; % Kreisfrequenz
iL0 = 0;  % Anfangsstrom
Uc0 = 10;

% ------- Zustandsmodell der Schaltung fr t>0
A = [-R2/L, -1/L; 1/Cc, 0];    B = [1/L; 0];
C = eye(2,2);   D = 0;
x0 = [iL0; Uc0];
my_system = ss(A, B, C, D);   % Definieren des SS-Systems

% ------- Spannung ug, Strom iL, Spannung uL
dt = 0.01;
Tfinal = 10;

t = 0:dt:Tfinal;
ug2 = ug2_ampl*cos(omega*t + phi);

% ------- Berechnung des Zustandsvektors
x = lsim(my_system, ug2',t',x0);
iL = x(:,1);
uc = x(:,2);

% ------- Darstellungen
figure(1);    clf;
subplot(311), plot(t, ug2);
title('Anregungsspannung ug2');
xlabel('Zeit in s');    grid on;

subplot(312), plot(t, iL');
title('Strom iL');
xlabel('Zeit in s');    grid on;

subplot(313), plot(t, uc');
title('Spannung uc');
xlabel('Zeit in s');    grid on;



