% Skript aufgabe_4.m in dem ein RL-Netzwerk
% mit sinusfrmiger Anregung untersucht wird

clear;
% ------- Parameter
R2 = 3;         % Widerstand
L = 3;     % Induktivitt
T = L/R2;        % Zeitkonstante

ug2_ampl = 5;   % Amplitude Anregung
phi = pi/3;     % Nullphase
f = 1;       % Frequenz in Hz
omega = 2*pi*f; % Kreisfrequenz
iL0 = 2;  % Anfangsstrom

% ------- Impedanz der Reihenschaltung
Z = R2 + j*omega*L;

% ------- Spannung ug, Strom iL, Spannung uL
dt = 0.01;
Tfinal = 10;
t = 0:dt:Tfinal;

ug2 = ug2_ampl*cos(omega*t + phi);

iL = (iL0-ug2_ampl*cos(phi-atan2(omega*L, R2))/abs(Z))*exp(-t/T)+...
    ug2_ampl*cos(omega*t+phi-atan2(omega*L,R2))/abs(Z);

uL = -iL*R2 + ug2;

% ------- Darstellungen
figure(1);    clf;
subplot(311), plot(t, ug2);
title('Anregungsspannung ug2');
xlabel('Zeit in s');    grid on;

subplot(312), plot(t, iL');
title('Strom iL');
xlabel('Zeit in s');    grid on;

subplot(313), plot(t, uL');
title('Spannung uL');
xlabel('Zeit in s');    grid on;



