% Skript RL_sinus1.m in dem die Reihenschaltung
% RL fr eine sinusfrmige Anregung untersucht wird.

clear;

% ------- Parameter der Schaltung
Rs = 5;       L = 0.01;
iL0 = 2;

ug_ampl = 10;
f = 200;       T = 1/f;
omega = 2*pi*f;
phi = pi/3; 

% ------- Analytische Lsung
dt = T/200;
Tfinal = 5*T;
t = 0:dt:Tfinal;
nt = length(t);

ug = ug_ampl*cos(omega*t + phi);

% ------- Numerische Lsung (Euler Verfahren)

iL = zeros(1,nt);
uL = zeros(1,nt);
iL(1) = iL0;
ud = 0

% Numerische Annaeherung
for k = 1:nt-1
    if ug(k) >= 0;
        uL(k) = ug(k) - iL(k)*Rs;
        iL(k+1) = iL(k) + dt*uL(k)/L;
    else
        uL(k) = - iL(k)*Rs;
        iL(k+1) = iL(k) + dt*uL(k)/L;
    end;
end;
uR = iL*Rs;

figure(1);
plot(t, ug, t, uL, t, uR);
title(['Spannung ug,  uc,  uR (iL0 =',...
    num2str(iL0), ')']);
xlabel('Zeit in s');   grid on;
legend('ug', 'uL', 'uR');
