% Skript RL_sinus1.m in dem die Reihenschaltung
% RL fr eine sinusfrmige Anregung untersucht wird.

clear;

% ------- Parameter der Schaltung
R = 10;       L = 0.01;
iL0 = 2;

ug_ampl = 10;
f = 200;       T = 1/f;
omega = 2*pi*f;
phi = pi/3; 

% ------- Analytische Lsung
tau = L/R;
iL_ampl = ug_ampl/(sqrt((omega*L)^2 + R^2));
phi_i = atan2(-omega*L,R);

C_h = iL0 - iL_ampl*cos(phi + phi_i);

dt = T/100;
Tfinal = 5*T;
t = 0:dt:Tfinal;
nt = length(t);

iL = C_h*exp(-t/tau) + iL_ampl*cos(omega*t + phi + phi_i);
ug = ug_ampl*cos(omega*t + phi);
uR = iL*R;
uL = ug - uR; 


figure(1);
plot(t, ug, t, uL, t, uR);
title(['Spannung ug,  uc,  uR (iL0 =',...
    num2str(iL0), ')']);
xlabel('Zeit in s');   grid on;
legend('ug', 'uL', 'uR');

% ------- Numerische Lsung (Euler Verfahren)

iL = zeros(1,nt);
iL(1) = iL0;
% Numerische Annaeherung
for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(ug(k) - iL(k)*R)/L;
end;
uR = iL*R;
uL = ug - uR;

figure(2);
plot(t, ug, t, uL, t, uR);
title(['Spannung ug,  uc,  uR (iL0 =',...
    num2str(iL0), ')']);
xlabel('Zeit in s');   grid on;
legend('ug', 'uL', 'uR');
