% Skript RL_glaett1.m, in dem die RL-Reihenschaltung
% fr die Glttung einer pulsfrmigen Spannung
% eingesetzt wird

clear;
% ------- Parameter der Schaltung
R = 10;       L = 0.005;
iL0 = -0.1;
ug_ampl = 10;
f = 5000;       T = 1/f;
omega = 2*pi*f;
phi = pi/4; 
% ------- Numerische Lsung (Euler Verfahren)
tau = L/R;
dt = tau/100;    % Sehr kleine Schrittweite
Tfinal = 10*T;
t = 0:dt:Tfinal;
nt = length(t);
ug = sin(omega*t + phi);
schwelle = -0.5;    % Schwelle fr die Umwandlung einer
% Sinusfunktion in einer rechteckigen Funktion 
% Schwelle muss zwischen -1 bis i sein
ug = (sign(ug - schwelle)+1)*ug_ampl/2;
iL = zeros(1,nt);
iL(1) = iL0;
% Numerische Annherung
for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(ug(k) - iL(k)*R)/L;
end;
uR = iL*R;
uL = ug - uR;

figure(1);
plot(t, ug, t, uR, t, uL);
title('Spannung ug,  uR,  uL');
xlabel('Zeit in s');   grid on;
legend('ug', 'uR', 'uL');

figure(2);
subplot(211), plot(t, ug, t, uL);
title('Spannung ug,  uL');
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, uR);
title('Spannung uR');
xlabel('Zeit in s');   grid on;


