% Skript RL_1.m in dem die Antwort
% einer Reihenschaltung RL auf eine 
% konstante Spannung, die bei t = 0 
% zugeschaltet wird, ermittelt ist

clear

% ------ Parameter der Schaltung
R = 10;    L = 0.001;
tau = L/R;  % Zeitkonstante
Ug = 10;
iL0 = -0.1;

% ------ Analytische Lsung
Tfinal = 5*tau;    % Darstellungszeit
dt = tau/100;      % Zeitschritt
t = 0:dt:Tfinal;
nt = length(t);

iL = iL0*exp(-t/tau) + Ug*(1-exp(-t/tau))/R;
ug = Ug*ones(1,nt);  % Eingangsspannung
uL = (ug-iL*R);        % Spannung am Widerstand       


%#####################
figure(1);
plot(t, ug, t, uL, t, iL*R)
title(['Eingangsspannung ug, Spannung uL und Spannung iL*R (iL0 = ',...
    num2str(iL0),')']);
xlabel('Zeit in s');  grid on;
La = axis;    axis([La(1), max(t), La(3:4)]);

% ------- Numerische Lsung (Euler Verfahren)
%dt1 = tau/200;    % Sehr kleine Schrittweite
%Tfinal = 5*tau;
%t = 0:dt1:Tfinal;

nt = length(t);
ug = Ug*ones(1,nt);
iL = zeros(1,nt);
iL(1) = iL0;

% Numerische Annaeherung
for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(ug(k) - iL(k)*R)/L;
end;
uL = ug - iL*R;

figure(2);
plot(t, ug, t, uL, t, iL*R)
title(['Eingangsspannung ug, Spannung uL und Spannung iL*R (iL0 = ',...
    num2str(iL0),')']);
xlabel('Zeit in s');  grid on;
La = axis;    axis([La(1), max(t), La(3:4)]);

