% Programm RLC_parallel3.m in dem der Amplitudengang
% und Phasengang einer R,L,C Schaltung ermittelt wird

clear;
% ------- Parameter des Systems
R = 50;      L = 0.005;     C = 0.0001;
Rs = 100;
Re = R*Rs/(R + Rs);

% Koeffizienten der charakteristischen Gl.
char = [1, 1/(R*C), 1/(C*L)];
% Wurzeln der charakteristischen Gl.
lambda = roots(char)
sigma = real(lambda(1));     % Dmpfung
omega_0 = imag(lambda(1));   % Eigenfrequenz

% Resonanzfrequenz
fr0 = 1/(2*pi*sqrt(L*C))
f0 = omega_0/(2*pi)   % Eigenfrequenz

% ------- Amplitudengang
df = 1;
f = 0:df:1000;
omega = 2*pi*f;

A = (1/R)*(1./sqrt((1/Re)^2 + (omega*C-1./(omega*L)).^2));
% ------- Phasengang
phi = atan2(-(omega*C-1./(omega*L)),1/Re);

figure(1);
subplot(211), plot(f, A);
hold on;
La = axis;
plot([fr0, fr0], [La(3), La(4)], 'r');
title('Amplitudengang');
xlabel('Frequenz in Hz');    grid on;
hold off;

subplot(212), plot(f, phi*180/pi);
hold on;
La = axis;
plot([fr0, fr0], [La(3), La(4)], 'r');
title('Phasengang');
xlabel('Frequenz in Hz');    grid on;
ylabel('Grad');
hold off;