% Programm RLC_parallel2.m in dem die Antwort
% auf eine sinusfrmige Spannung fr eine parallele
% R,L,C Schaltung ermittelt wird

clear;

% ------- Parameter des Systems
R = 50;      L = 0.005;     C = 0.0001;
Rs = 100;
Re = R*Rs/(R + Rs);
uc0 = 1;     iL0 = 0.3;

ug_ampl = 10;
%f = 225,0791;    % Resonanzfrequenz  
f = 50.0;         % Anregungsfrequenz
omega = 2*pi*f;
phi = pi/3;

% Koeffizienten der charakteristischen Gl.
char = [1, 1/(R*C), 1/(C*L)];
% Wurzeln der charakteristischen Gl.
lambda = roots(char)

sigma = real(lambda(1));     % Dmpfung
omega_0 = imag(lambda(1));   % Eigenfrequenz

% Resonanzfrequenz
fr0 = 1/(2*pi*sqrt(L*C))
f0 = omega_0/(2*pi)   % Eigenfrequenz

% -------- Lsung durch Simulation
% mit Euler-Verfahren und Zustandsdifferentialgl.
T = 2*pi/omega        % Periode der Anregung
dt = T/100;         Tfinal = 8*T;
t = 0:dt:Tfinal;

nt = length(t);
ug = ug_ampl*cos(omega*t + phi);

iLs = zeros(nt,1);      % mit Index s fr die numerische 
                        % Integration
ucs = zeros(nt,1);
iLs(1) = iL0;      ucs(1) = uc0;

for k = 1:nt-1
    ucs(k+1) = ucs(k) + dt*(-ucs(k)/(Re*C) - iLs(k)/C + ug(k)/(R*C));
    iLs(k+1) = iLs(k) + dt*(ucs(k+1)/L);
end;
%#######################
figure(1);
plot(t, iLs);
title('Strom  iL');
xlabel('Zeit in s');   grid on;
hold on;
plot(t, ucs*0.2, 'r');
title(' Strom iL(t), Spannung uc(t)*0.2');
legend('iL', '0.2*uC');
hold off;



