% Programm RLC_parallel1_1.m in dem die Antwort
% auf eine konstante Spannung fuer eine parallele
% R,L,C Schaltung ermittelt wird

clear;

% ------- Parameter des Systems
R = 50;      L = 0.005;     C = 0.0001;
uc0 = 0;     iL0 = 0.5;
Ug = 10;
% Koeffizienten der charakteristischen Gl.
char = [1, 1/(R*C), 1/(C*L)];
% Wurzeln der charakteristischen Gl.
lambda = roots(char)

sigma = real(lambda(1));   % Daempfung
omega_0 = imag(lambda(1));   % Eigenfrequenz
phi_0 = atan2(sigma, omega_0);
A2b = (iL0-Ug/R)/cos(phi_0);

% ------ Die analytische Loesung
T = 2*pi/omega_0        % Periode der Eigenschwingung
dt = T/100; 
Tfinal = 10*T;

t = 0:dt:Tfinal;
iL = Ug/R + A2b*exp(sigma*t).*cos(omega_0*t + phi_0); % Analytisch

% -------- Loesung durch Simulation
% mit Euler-Verfahren und Zustandsdifferentialgl.

nt = length(t);
iLs = zeros(nt,1);   % mit Index s fr die numerische 
% Integration
ucs = zeros(nt,1);
iLs(1) = iL0;      ucs(1) = uc0;

for k = 1:nt-1
    ucs(k+1) = ucs(k) + dt*(-ucs(k)/(R*C) - iLs(k)/C + Ug/(R*C));
    iLs(k+1) = iLs(k) + dt*(ucs(k+1)/L);
end;
%#######################
figure(1);
plot(t, iL);
title('Strom  iL');
xlabel('Zeit in s');   grid on;
hold on;
    
plot(t, ucs*0.2, 'r');
plot(t, iLs, 'k');
hold off;
title(' Strom iL(t), Spannung uc(t)*0.2');
legend('iL', '0.2*uc', 'iL (simuliert)');

% -------- Loesung durch Simulation
% mit modifiziertem Euler-Verfahren und Zustandsdifferentialgl.

nt = length(t);
iLs = zeros(nt,1);   % mit Index s fr die numerische 
% Integration
ucs = zeros(nt,1);
iLs(1) = iL0;      ucs(1) = uc0;

for k = 1:nt-1
    ucs(k+1) = ucs(k) + dt*(-ucs(k)/(R*C) - iLs(k)/C + Ug/(R*C));
    iLs(k+1) = iLs(k) + dt*(ucs(k)/L);
    ucs(k+1) = ucs(k) + (dt/2)*(-ucs(k)/(R*C) - iLs(k)/C + Ug/(R*C)+...
        -ucs(k+1)/(R*C) - iLs(k+1)/C + Ug/(R*C));
    iLs(k+1) = iLs(k) + (dt/2)*(ucs(k)/L + ucs(k+1)/L);    
end;
%#######################
figure(2);
plot(t, iL);
title('Strom  iL');
xlabel('Zeit in s');   grid on;
hold on;
    
plot(t, ucs*0.2, 'r');
plot(t, iLs, 'k');
hold off;
title(' Strom iL(t), Spannung uc(t)*0.2');
legend('iL', '0.2*uc', 'iL (simuliert)');


