% Skript RLC_konst2.m in dem die Antwort einer
% RLC-Reihenschaltung auf eine konstante Anregung
% untersucht wird


clear

% ------- Parameter des Systems
% Fall 1:
R1 = 100;     L = 2e-3;
C = 10e-6;
iL0 = 0.1;
uc0 = -1;

Ug = 10;

a1 = [1, R1/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lamda1 = roots(a1)        % Wurzel der charak. Gl.

% Fall 2:
R2 = sqrt(4*L/C); 

a2 = [1, R2/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lamda2 = roots(a2)        % Wurzel der charak. Gl.

% Fall 3:
R3 = 5; 

a3 = [1, R3/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lamda3 = roots(a3)        % Wurzel der charak. Gl.

% ------ Matrizen des Systems von Differentialgleichungen
% erster Ordnung
A1 = [-R1/L, -1/L; 1/C, 0];
A2 = [-R2/L, -1/L; 1/C, 0];
A3 = [-R3/L, -1/L; 1/C, 0];

B = [1/L; 0];    

% ------ Numerische Integration
%Fall 1
dt = 0.00001;      Tfinal = 0.01;
t = 0:dt:Tfinal;
nt = length(t);

x1 = zeros(2,nt);  % Matrix fr iL un uc
% erste Zeile der Lnge nt fr iL
% zweite Zeile der Lnge nt fr uc

x1(:,1) = [iL0; uc0];
ug = Ug*ones(1,nt);
for k = 1:nt-1
    x1(:,k+1) = x1(:,k) + dt*(A1*x1(:, k) + B*ug(k));
end;

figure(1);
subplot(211), plot(t, x1(1,:));
title(['Strom   iL       lambda1 = ',num2str(lamda1(1,1)), ...
    ';     lambda2 = ',num2str(lamda1(2,1))]);
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, x1(2,:));
title('Spannung uc');
xlabel('Zeit in s');   grid on;

%Fall 2
dt = 0.00001;      Tfinal = 0.002;
t = 0:dt:Tfinal;
nt = length(t);

x2 = zeros(2,nt);
x2(:,1) = [iL0; uc0];
for k = 1:nt-1
    x2(:,k+1) = x2(:,k) + dt*(A2*x2(:, k) + B*ug(k));
end;

figure(2);
subplot(211), plot(t, x2(1,:));
title(['Strom   iL       lambda1 = ',num2str(lamda2(1,1)), ...
    ';     lambda2 = ',num2str(lamda2(2,1))]);
xlabel('Zeit in s');   grid on;
subplot(212), plot(t, x2(2,:));
title('Spannung uc');
xlabel('Zeit in s');   grid on;
    
%Fall 3
dt = 0.00001;      Tfinal = 0.005;
t = 0:dt:Tfinal;
nt = length(t);

x3 = zeros(2,nt);
x3(:,1) = [iL0; uc0];
for k = 1:nt-1
    x3(:,k+1) = x3(:,k) + dt*(A3*x3(:, k) + B*ug(k));
end;

figure(3);
subplot(211), plot(t, x3(1,:));
title(['Strom   iL       lambda1 = ',num2str(lamda3(1,1)), ...
    ';     lambda2 = ',num2str(lamda3(2,1))]);
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, x3(2,:));    
title('Spannung uc');
xlabel('Zeit in s');   grid on;    
    
    
    
    
    
    