% Skript RLC_konst2.m in dem die Antwort einer
% RLC-Reihenschaltung auf eine konstante Anregung
% untersucht wird

clear

% ------- Parameter des Systems
% Fall 1:
R1 = 100;     L = 2e-3;
C = 10e-6;
iL0 = 0.1;
uc0 = -1;

Ug = 10;

a1 = [1, R1/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lambda1 = roots(a1)        % Wurzel der charak. Gl.

% Fall 2:
R2 = sqrt(4*L/C); 

a2 = [1, R2/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lambda2 = roots(a2)        % Wurzel der charak. Gl.

% Fall 3:
R3 = 5; 

a3 = [1, R3/L, 1/(C*L)];   % Koeffizienten 
% der charakteristischen Gleichung
lambda3 = roots(a3)        % Wurzel der charak. Gl.

% ------ Numerische Integration
%Fall 1
dt = 0.00001;      Tfinal = 0.01;
t = 0:dt:Tfinal;
nt = length(t);

ug = Ug*ones(1,nt);
iL = zeros(1,nt);  uc = zeros(1,nt);
iL(1) = iL0;       uc(1) = uc0;

for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(-R1*iL(k) - uc(k) + ug(k))/L;
    uc(k+1) = uc(k) + dt*iL(k)/C;
end;

figure(1);
subplot(211), plot(t, iL);
title(['Strom   iL       lambda1 = ',num2str(lambda1(1,1)), ...
    ';     lambda2 = ',num2str(lambda1(2,1))]);
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, uc);
title('Spannung uc');
xlabel('Zeit in s');   grid on;

%Fall 2
dt = 0.00001;      Tfinal = 0.002;
t = 0:dt:Tfinal;
nt = length(t);

ug = Ug*ones(1,nt);
iL = zeros(1,nt);  uc = zeros(1,nt);
iL(1) = iL0;       uc(1) = uc0;

for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(-R2*iL(k) - uc(k) + ug(k))/L;
    uc(k+1) = uc(k) + dt*iL(k)/C;
end;

figure(2);
subplot(211), plot(t, iL);
title(['Strom   iL       lambda1 = ',num2str(lambda2(1,1)), ...
    ';     lambda2 = ',num2str(lambda2(2,1))]);
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, uc);
title('Spannung uc');
xlabel('Zeit in s');   grid on;

%Fall 3
dt = 0.00001;      Tfinal = 0.01;
t = 0:dt:Tfinal;
nt = length(t);

ug = Ug*ones(1,nt);
iL = zeros(1,nt);  uc = zeros(1,nt);
iL(1) = iL0;       uc(1) = uc0;

for k = 1:nt-1
    iL(k+1) = iL(k) + dt*(-R3*iL(k) - uc(k) + ug(k))/L;
    uc(k+1) = uc(k) + dt*iL(k)/C;
end;

figure(3);
subplot(211), plot(t, iL);
title(['Strom   iL       lambda1 = ',num2str(lambda3(1,1)), ...
    ';     lambda2 = ',num2str(lambda3(2,1))]);
xlabel('Zeit in s');   grid on;

subplot(212), plot(t, uc);
title('Spannung uc');
xlabel('Zeit in s');   grid on;
    
    
    
    
    